//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.IO;
using System.Runtime.Remoting;

using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Http;

namespace CLRUnleashed.Remoting
{
	/// <summary>
	/// Podsumowanie dla TimeServer.
	/// </summary>
	class TimeServer
	{
		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			string configfile = "timeserver.exe.config";

			if(args.Length != 0)
				configfile = args[0];

			if(!Initialize(configfile))
				return;

			String keyState = "";
			Console.WriteLine("Wcinij <cr>, aby wyj");
			keyState = Console.ReadLine();

		}
		static bool Initialize(string configfile)
		{
			if(!File.Exists(configfile))
			{
				configfile = @"..\..\" + configfile;
				if(!File.Exists(configfile))
					return false;
			}
			RemotingConfiguration.Configure(configfile);
			return true;
		}
	}
}
